<?php

/** @var yii\web\View $this */
/** @var string $content */

use app\assets\AppAsset;
use app\models\Empresa;
use app\models\Instituto;
use app\models\Parametros;
use app\widgets\Alert;
use yii\bootstrap5\Breadcrumbs;
use yii\bootstrap5\Html;
use yii\bootstrap5\NavBar;
use yii\bootstrap5\Nav;


$controllerName = Yii::$app->controller->id;
$controladorLabel = $controllerName;




$actionName = Yii::$app->controller->action->id;

if ($actionName == 'separados' || $actionName == 'updateseparado') {
  $controladorLabel = 'separados';
}


$userModel = Yii::$app->user->identity;
$empresa = Empresa::find()->where(['codigo' => Parametros::empresa])->one();





AppAsset::register($this);

$this->registerCsrfMetaTags();
$this->registerMetaTag(['charset' => Yii::$app->charset], 'charset');
$this->registerMetaTag(['name' => 'viewport', 'content' => 'width=device-width, initial-scale=1, shrink-to-fit=no']);
$this->registerMetaTag(['name' => 'description', 'content' => $this->params['meta_description'] ?? '']);
$this->registerMetaTag(['name' => 'keywords', 'content' => $this->params['meta_keywords'] ?? '']);
$this->registerLinkTag(['rel' => 'icon', 'type' => 'image/x-icon', 'href' => Yii::getAlias('@web/favicon.ico')]);
?>
<?php $this->beginPage() ?>
<!DOCTYPE html>
<html lang="<?= Yii::$app->language ?>" class="h-100">

<head>
  <title><?= Html::encode($this->title) ?></title>
  <?php $this->head() ?>
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css" />

  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" integrity="sha512-DTOQO9RWCH3ppGqcWaEA1BIZOC6xxalwEsw9c2QQeAIftl+Vegovlnee1c9QX4TctnWMn13TZye+giMm8e2LwA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
  <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js" integrity="sha384-C6RzsynM9kWDrMNeT87bh95OGNyZPhcTNXj1NW7RuBCsyN/o0jlpcV8Qyq46cDfL" crossorigin="anonymous"></script>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-T3c6CoIi6uLrA9TneNEoa7RxnatzjcDSCmG1MXxSR1GAsXEV/Dwwykc2MPK8M2HN" crossorigin="anonymous">


  <link href='https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css' rel='stylesheet'>



  <link
    href="https://fonts.googleapis.com/css2?family=Public+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap"
    rel="stylesheet" />


  <style>
    body {
      font-family: 'Public Sans', sans-serif;
    }

    h1,
    h2,
    h3 {
      font-weight: 500;
      /* Usa el peso de fuente que has importado */
      color: #515050;
    }

    h4 {
      color: dimgray;
    }

    .text-primary {
      color: #696cff !important;
    }



    .help-block {
      font-size: 12px;
      color: #ab0d0d;
    }

    .btn-primary {
      background-color: purple;
      border: none;
      padding: 5px 15px;
    }

    .btn-primary:hover {
      background-color: purple;
      opacity: 0.90;
    }



    a.nav-link {
      color: #697a8d;
      font-size: 15px;
      padding: 10px 34px;
      border-radius: 12px;
    }

    a.nav-link:hover {
      color: #696cff;
      background-color: rgba(105, 108, 255, 0.16) !important;
    }



    a.nav-selected {
      color: #ffffff;
      background-color: #696cffc9;
    }



    a.nav-link i {
      padding-right: 16px;
    }


    label {
      color: #566A7F;
    }

    .btn-outline-primary {
      color: #696cff;
      border-color: #696cff;
      background: transparent;
    }


    .btn-outline-primary:hover {
      color: #ffffff;
      border-color: #696cff;
      background: #696cff;
    }


    .breadcrumb-item a {
      color: #696cff;
    }


    .btn-success {
      background-color: #696cff;
      border: none;
    }


    .btn-success:hover {
      background-color: #696cff;
      border: none;
    }


    .btn-success:disabled {
      background-color: #696cff;
      border: none;
      cursor: not-allowed;
      /* Cambiar el cursor para indicar que está deshabilitado */
      opacity: 0.65;
      /* Reducir la opacidad */
    }


    th a {
      color: #696cff;
    }





    .card {
      position: relative;
      display: flex;
      flex-direction: column;
      min-width: 0;
      word-wrap: break-word;
      background-color: #fff;
      background-clip: border-box;
      border: 0 solid #d9dee3;
      border-radius: 0.5rem;
      box-shadow: 0 2px 6px 0 rgba(67, 89, 113, 0.12);
    }

    .card>hr {
      margin-right: 0;
      margin-left: 0;
    }

    .card>.list-group {
      border-top: inherit;
      border-bottom: inherit;
    }

    .card>.list-group:first-child {
      border-top-width: 0;
      border-top-left-radius: 0.5rem;
      border-top-right-radius: 0.5rem;
    }

    .card>.list-group:last-child {
      border-bottom-width: 0;
      border-bottom-right-radius: 0.5rem;
      border-bottom-left-radius: 0.5rem;
    }

    .card>.card-header+.list-group,
    .card>.list-group+.card-footer {
      border-top: 0;
    }

    .card-body {
      flex: 1 1 auto;
      padding: 1.5rem 1.5rem;
    }

    .card-title {
      margin-bottom: 0.875rem;
    }

    .card-subtitle {
      margin-top: -0.4375rem;
      margin-bottom: 0;
    }

    .card-text:last-child {
      margin-bottom: 0;
    }

    .card-link+.card-link {
      margin-left: 1.5rem;
    }

    .card-header {
      padding: 1.5rem 1.5rem;
      margin-bottom: 0;
      background-color: transparent;
      border-bottom: 0 solid #d9dee3;
      padding-bottom: 0px;
      font-size: 18px;
      color: #566A7F;
    }

    .card-header:first-child {
      border-radius: 0.5rem 0.5rem 0 0;
    }

    .card-footer {
      padding: 1.5rem 1.5rem;
      background-color: transparent;
      border-top: 0 solid #d9dee3;
    }

    .card-footer:last-child {
      border-radius: 0 0 0.5rem 0.5rem;
    }

    .card-header-tabs {
      margin-right: -0.75rem;
      margin-bottom: -1.5rem;
      margin-left: -0.75rem;
      border-bottom: 0;
    }

    .card-header-pills {
      margin-right: -0.75rem;
      margin-left: -0.75rem;
    }

    .card-img-overlay {
      position: absolute;
      top: 0;
      right: 0;
      bottom: 0;
      left: 0;
      padding: 1.5rem;
      border-radius: 0.5rem;
    }

    .card-img,
    .card-img-top,
    .card-img-bottom {
      width: 100%;
    }

    .card-img,
    .card-img-top {
      border-top-left-radius: 0.5rem;
      border-top-right-radius: 0.5rem;
    }

    .card-img,
    .card-img-bottom {
      border-bottom-right-radius: 0.5rem;
      border-bottom-left-radius: 0.5rem;
    }

    .card-group>.card {
      margin-bottom: 0.8125rem;
    }

    @media (min-width: 576px) {
      .card-group {
        display: flex;
        flex-flow: row wrap;
      }

      .card-group>.card {
        flex: 1 0 0%;
        margin-bottom: 0;
      }

      .card-group>.card+.card {
        margin-left: 0;
        border-left: 0;
      }

      .card-group>.card:not(:last-child) {
        border-top-right-radius: 0;
        border-bottom-right-radius: 0;
      }

      .card-group>.card:not(:last-child) .card-img-top,
      .card-group>.card:not(:last-child) .card-header {
        border-top-right-radius: 0;
      }

      .card-group>.card:not(:last-child) .card-img-bottom,
      .card-group>.card:not(:last-child) .card-footer {
        border-bottom-right-radius: 0;
      }

      .card-group>.card:not(:first-child) {
        border-top-left-radius: 0;
        border-bottom-left-radius: 0;
      }

      .card-group>.card:not(:first-child) .card-img-top,
      .card-group>.card:not(:first-child) .card-header {
        border-top-left-radius: 0;
      }

      .card-group>.card:not(:first-child) .card-img-bottom,
      .card-group>.card:not(:first-child) .card-footer {
        border-bottom-left-radius: 0;
      }
    }


    .btn-xs {
      padding: 0.25rem 0.5rem;
      font-size: 0.75rem;
      line-height: 1;
      border-radius: 0.2rem;
    }



    .text-uppercase {
      text-transform: uppercase !important;
    }

    small,
    .small {
      font-size: 85%;
    }

    .menu-header {
      color: #a1acb8;
      margin-left: 25px;
    }


    .divisor {
      height: 2px;
      background-color: #f1f1f1;
      border: none;
    }
  </style>
</head>

<body class="d-flex flex-column h-100">
  <?php $this->beginBody() ?>

  <div class="container-fluid">
    <div class="row">
      <nav id="sidebar" class="col-md-2 col-lg-2 d-md-block sidebar position-fixed" style="background: rgb(25,60,120); background: white; height: 100vh; box-shadow: 0 2px 6px 0 rgba(67, 89, 113, 0.12); overflow-y: auto;">
        <!-- Contenido del sidebar -->
        <div class="position-sticky">
          <ul class="nav flex-column">
            <!-- ITEMS DE MENU -->


            <li style="margin-top: 70px;">


              <img style=" display: block; max-width: 70%; margin: auto;" class="img-fluid" src="<?= Yii::$app->urlManager->baseUrl . '/uploads/images/' . $empresa->logotipo ?>" alt="">

              <div class="pt-4" style="padding-left: 20px;">
                <span>Bienvenido/a <?= $userModel->nombre ?? '' ?></span><br>
                <i style=" font-size: 12px;"><?= $userModel->rol ?? '' ?> / <?= $empresa->nombre ?></i>
              </div>






            </li>

            <hr class="divisor">



            <br>

            <li class="menu-header small text-uppercase mb-2">
              <span class="menu-header-text">Menú</span>
            </li>




            <?php

            if (!empty($userModel->rol) && $userModel->rol === 'superAdmin') { ?>

              <li class="nav-item">
                <?= Html::a('<i class="bx bxs-dashboard bx-sm"></i> Dashboard', ['/site/ingresar-dashboard'], ['class' => 'nav-link ' . ($controllerName === 'site' && $actionName !== 'register'  ? 'nav-selected' : '')]) ?>
              </li>

              <hr class="divisor">
              </li>

              <li class="menu-header small text-uppercase mb-2">
                <span class="menu-header-text">Configuración</span>
              </li>

              <li class="nav-item">
                <?= Html::a('<i class="bx bx-laptop bx-sm"></i> Landing Page', ['/empresa/update'], ['class' => 'nav-link ' . ($controllerName === 'empresa' ? 'nav-selected' : '')]) ?>
              </li>

              <li class="nav-item">
                <?= Html::a('<i class="bx bx-git-branch bx-sm"></i> Categorias', ['/categorias/index'], ['class' => 'nav-link ' . ($controllerName === 'categorias' ? 'nav-selected' : '')]) ?>
              </li>


              <li class="nav-item">
                <?= Html::a('<i class="bx bx-git-branch bx-sm"></i> Marcas', ['/marcas/index'], ['class' => 'nav-link ' . ($controllerName === 'marcas' ? 'nav-selected' : '')]) ?>
              </li>


              <li class="nav-item">
                <?= Html::a('<i class="bx bx-git-branch bx-sm"></i> Colores', ['/colores/index'], ['class' => 'nav-link ' . ($controllerName === 'colores' ? 'nav-selected' : '')]) ?>
              </li>

              <hr class="divisor">

              <li class="menu-header small text-uppercase mb-2 mt-3">
                <span class="menu-header-text">Registros</span>
              </li>

              <li class="nav-item">
                <?= Html::a('<i class="bx bxs-user bx-sm"></i> Usuarios', ['/user/index'], ['class' => 'nav-link ' . ($controllerName === 'user' || ($controllerName === 'site' && $actionName == 'register') ? 'nav-selected' : '')]) ?>
              </li>

              <li class="nav-item">
                <?= Html::a('<i class="bx bx-user bx-sm"></i> Clientes', ['/clientes/index'], ['class' => 'nav-link ' . ($controllerName === 'clientes' ? 'nav-selected' : ''), 'target' => '_blank']) ?>
              </li>


              <li class="nav-item">
                <?= Html::a('<i class="bx bx-package bx-sm"></i> Proveedores', ['/proveedores/index'], ['class' => 'nav-link ' . ($controllerName === 'proveedores' ? 'nav-selected' : '')]) ?>
              </li>

              <li class="nav-item">
                <?= Html::a('<i class="bx bx-barcode bx-sm"></i> Productos', ['/productos/index'], ['class' => 'nav-link ' . ($controllerName === 'productos' ? 'nav-selected' : ''), 'target' => '_blank']) ?>
              </li>

              <hr class="divisor">

              <li class="menu-header small text-uppercase mb-2 mt-3">
                <span class="menu-header-text">Facturación y otros</span>
              </li>

              <li class="nav-item">

                <?= Html::a('<i class="bx bx-cart-add bx-sm"></i> Crear Nota de Venta', ['/facturas/create'], ['class' => 'nav-link ' . ($controllerName === 'facturas' && $actionName !== 'index' && $actionName !== 'separados' && $actionName !== 'updateseparados' ? 'nav-selected' : '')]) ?>

              </li>



              <li class="nav-item">
                <?= Html::a('<i class="bx bxs-dashboard bx-sm"></i> Separados', ['/facturas/separados'], ['class' => 'nav-link ' . ($controllerName === 'facturas' && ($actionName == 'separados' || $actionName == 'updateseparado')  ? 'nav-selected' : '')]) ?>

              </li>

              <hr class="divisor">

              <li class="menu-header small text-uppercase mb-2 mt-3">
                <span class="menu-header-text">Gastos</span>
              </li>

              <li class="nav-item">
                <?= Html::a('<i class="bx bx-coin-stack bx-sm"></i> Tipo de gastos', ['/tipogastos/index'], ['class' => 'nav-link ' . ($controllerName === 'tipogastos' ? 'nav-selected' : '')]) ?>
              </li>

              <li class="nav-item">
                <?= Html::a('<i class="bx bx-coin-stack bx-sm"></i> Gastos', ['/gastos/index'], ['class' => 'nav-link ' . ($controllerName === 'gastos' ? 'nav-selected' : '')]) ?>
              </li>

              <hr class="divisor">

              <li class="menu-header small text-uppercase mb-2 mt-3">
                <span class="menu-header-text">Reportes</span>
              </li>



              <li class="nav-item">
                <?= Html::a('<i class="bx bx-cart-add bx-sm"></i> Ventas', ['/facturas/index'], ['class' => 'nav-link ' . ($controllerName === 'facturas' && $actionName == 'index' ? 'nav-selected' : '')]) ?>
              </li>

              <li class="nav-item">
                <?= Html::a('<i class="bx bx-git-branch bx-sm"></i> Productos vendidos', ['/detallefacturas/index'], ['class' => 'nav-link ' . ($controllerName === 'detallefacturas' ? 'nav-selected' : '')]) ?>
              </li>


              <li class="nav-item">
                <?= Html::a('<i class="bx bx-git-branch bx-sm"></i> Cuadre de caja', ['/valores/cuadrar-valores'], ['class' => 'nav-link ' . ($controllerName === 'valores' ? 'nav-selected' : ''), 'target' => '_blank']) ?>
              </li>

            <?php  }
            ?>



            <?php

            if (!empty($userModel->rol) && $userModel->rol === 'vendedor') { ?>



              <hr class="divisor">
              </li>

              <li class="menu-header small text-uppercase mb-2">
                <span class="menu-header-text">Configuración</span>
              </li>



              <li class="nav-item">
                <?= Html::a('<i class="bx bx-git-branch bx-sm"></i> Categorias', ['/categorias/index'], ['class' => 'nav-link ' . ($controllerName === 'categorias' ? 'nav-selected' : '')]) ?>
              </li>


              <li class="nav-item">
                <?= Html::a('<i class="bx bx-git-branch bx-sm"></i> Marcas', ['/marcas/index'], ['class' => 'nav-link ' . ($controllerName === 'marcas' ? 'nav-selected' : '')]) ?>
              </li>


              <li class="nav-item">
                <?= Html::a('<i class="bx bx-git-branch bx-sm"></i> Colores', ['/colores/index'], ['class' => 'nav-link ' . ($controllerName === 'colores' ? 'nav-selected' : '')]) ?>
              </li>

              <hr class="divisor">

              <li class="menu-header small text-uppercase mb-2 mt-3">
                <span class="menu-header-text">Registros</span>
              </li>



              <li class="nav-item">
                <?= Html::a('<i class="bx bx-user bx-sm"></i> Clientes', ['/clientes/index'], ['class' => 'nav-link ' . ($controllerName === 'clientes' ? 'nav-selected' : '')]) ?>
              </li>




              <li class="nav-item">
                <?= Html::a('<i class="bx bx-barcode bx-sm"></i> Productos', ['/productos/index'], ['class' => 'nav-link ' . ($controllerName === 'productos' ? 'nav-selected' : '')]) ?>
              </li>

              <hr class="divisor">

              <li class="menu-header small text-uppercase mb-2 mt-3">
                <span class="menu-header-text">Facturación y otros</span>
              </li>


              <li class="nav-item">

                <?= Html::a('<i class="bx bx-cart-add bx-sm"></i> Crear Nota de Venta', ['/facturas/create'], ['class' => 'nav-link ' . ($controllerName === 'facturas' && $actionName !== 'index' ? 'nav-selected' : '')]) ?>

              </li>





              <li class="nav-item">
                <?= Html::a('<i class="bx bx-shopping-bag bx-sm"></i> Separados', ['/facturas/index'], ['class' => 'nav-link ' . ($controllerName === 'separados' ? 'nav-selected' : '')]) ?>
              </li>

              <hr class="divisor">

              <li class="menu-header small text-uppercase mb-2 mt-3">
                <span class="menu-header-text">Gastos</span>
              </li>

              <li class="nav-item">
                <?= Html::a('<i class="bx bx-coin-stack bx-sm"></i> Tipo de gastos', ['/tipogastos/index'], ['class' => 'nav-link ' . ($controllerName === 'tipogastos' ? 'nav-selected' : '')]) ?>
              </li>

              <li class="nav-item">
                <?= Html::a('<i class="bx bx-coin-stack bx-sm"></i> Gastos', ['/gastos/index'], ['class' => 'nav-link ' . ($controllerName === 'gastos' ? 'nav-selected' : '')]) ?>
              </li>

              <hr class="divisor">

              <li class="menu-header small text-uppercase mb-2 mt-3">
                <span class="menu-header-text">Reportes</span>
              </li>



              <li class="nav-item">
                <?= Html::a('<i class="bx bx-cart-add bx-sm"></i> Ventas', ['/facturas/index'], ['class' => 'nav-link ' . ($controllerName === 'facturas' && $actionName == 'index' ? 'nav-selected' : '')]) ?>
              </li>

            <?php  }
            ?>




            <!-- ******************************** TECNICENTRO DEL CALEFON ********************* -->
            <!-- =============================================================================  -->


            <?php
            if (!empty($userModel->rol) && ($userModel->rol === 'superAdmin' || $userModel->rol === 'vendedor') && Parametros::empresa == 'tecnicentro') { ?>

              <hr class="divisor">
              <li class="menu-header small text-uppercase mb-2 mt-3">
                <span class="menu-header-text">Solicitudes</span>
              </li>

              <li class="nav-item">
                <?= Html::a('<i class="bx bx-git-branch bx-sm"></i> Solicitudes', ['/solicitudes/index'], ['class' => 'nav-link ' . ($controllerName === 'solicitudes' ? 'nav-selected' : '')]) ?>
              </li>

            <?php  }
            ?>



            <div style="height: 60px;"></div>





          </ul>
        </div>
      </nav>




      <main id="main" class="col-md-10 ms-sm-auto col-lg-10 px-md-4" role="main" style="background-color: #f5f5f9; min-height: 100vh;">



        <div class="row">
          <div class="col-md-12" style="display: flex; justify-content: end;">
            <a style="color:grey; text-decoration: none;margin-top: 15px;" href="<?= \yii\helpers\Url::to(['site/logout']) ?>" data-method="post">Cerrar sesión <i class="fas fa-sign-out-alt"></i></a>
          </div>
        </div>
        <!-- Contenido principal -->
        <div class="container" style="padding: 20px 15px 20px;">


          <?php
          if ($actionName !== 'index' && $controllerName !== 'site' &&  $controllerName !== 'empresa') {  ?>
            <div class="pb-2">
              <a style="font-weight: 600; cursor: pointer;" onclick="irInicio()">Home / </a> <a style="font-weight: 600; color: #1c8995; cursor: pointer;" onclick="irController()"><?= $controladorLabel ?></a>
            </div>
          <?php  }
          ?>




          <?= Alert::widget() ?>
          <?= $content ?>
        </div>


        <!--div style="position: absolute; right: 20px; bottom: 20px;">
                <script src="https://unpkg.com/@dotlottie/player-component@latest/dist/dotlottie-player.mjs" type="module"></script> 
                <dotlottie-player src="https://lottie.host/4d6f9791-d11e-472e-8806-db71d30b9acb/LbZ18p3ueN.json" background="transparent" speed="1" style="width: 150px; height: 150px;" loop autoplay></dotlottie-player>
            </!--div-->

      </main>
    </div>
  </div>

  <?php $this->endBody() ?>
</body>

</html>
<?php $this->endPage() ?>


<script>
  $('table').removeClass('table-striped table-bordered');

  function irInicio() {
    window.location.href = 'index.php?r=site/ingresar-dashboard';
  }

  function irController() {
    let actionAct = '<?= $actionName ?>'; // Asegúrate de que $actionName devuelva una cadena válida
    let controllerName = '<?= $controllerName ?>'; // Asegúrate de que $controllerName esté bien definido

    if (actionAct === 'separados' || actionAct === 'updateseparado') {
      window.location.href = 'index.php?r=' + controllerName + '/separados';
    } else {
      window.location.href = 'index.php?r=' + controllerName + '/index';
    }
  }
</script>